/**
 * 
 */
package com.ejie.ab18a.webservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import n38a.exe.N38APISesion;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.ejie.ab18a.model.Ab18aAplicacionInvocante;
import com.ejie.ab18a.model.Ab18aErrorAplicacion;
import com.ejie.ab18a.model.Ab18aMensajeEvento;
import com.ejie.ab18a.model.Ab18aPeticionEnvio;
import com.ejie.ab18a.properties.Ab18aPropertiesManager;
import com.ejie.ab18a.service.Ab18aAplicacionInvocanteService;
import com.ejie.ab18a.service.Ab18aErrorAplicacionService;
import com.ejie.ab18a.service.Ab18aPeticionEnvioService;
import com.ejie.ab18a.utils.Ab18aFechas;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.ab18a.ws.model.Ab18aDatosRespuestaEsentool;
import com.ejie.ab18a.ws.model.Ab18aValidacionBoletin;
import com.ejie.ab18a.ws.model.DatosBoletin;
import com.ejie.ab18a.ws.model.ErrorWS;
import com.ejie.ab18a.ws.model.RecogidaInformacionRequest;
import com.ejie.ab18a.ws.model.RecogidaInformacionResponse;

/**
 * @author XXXX
 * 
 */
@WebService(serviceName = "informacionBoletinWS", portName = "informacionBoletinWSPort", targetNamespace = "http://com.ejie.ab18a.webservice")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
// @HandlerChain(file = "server-handlers.xml")
public class Ab18aRecogidaInformacionImpl extends SpringBeanAutowiringSupport {

	private static final Logger logger = LoggerFactory.getLogger(Ab18aRecogidaInformacionImpl.class);

	private static final String ENTIDAD = "EventEntity";
	private static final String SISTEMA = "EventWho";
	private static final String TIPOLOGIA = "EventTipology";
	private static final String WHAT = "EventWhat";
	private static final String TIMESTAMP = "EventTimeStamp";
	// private static final String CORRELATIONID = "EventCorrelationId";
	// private static final String BODY = "NotificationBody";
	private static final String TOKEN_SESION = "TokenSesion";

	@Autowired()
	private Ab18aAplicacionInvocanteService aplicacionInvocanteService;

	@Autowired()
	private Ab18aErrorAplicacionService errorAplicacionService;

	@Autowired()
	private Ab18aPeticionEnvioService peticionEnvioService;

	/**
	 * Solicitud de información
	 * 
	 * @param request
	 *            RecogidaInformacionRequest
	 * @return RecogidaInformacionResponse
	 */
	@WebMethod
	public RecogidaInformacionResponse solicitarInformacion(RecogidaInformacionRequest request) {

		// Respuesta del WS
		RecogidaInformacionResponse response = new RecogidaInformacionResponse();
		response.setDatosBoletin(new DatosBoletin());

		// Aplicacion invocante
		Ab18aAplicacionInvocante aplicacionInvocante = null;

		// Listado de errores
		List<ErrorWS> listaErrores = new ArrayList<ErrorWS>();

		// Comprobamos que la request no este vacía
		if (Utilidades.notNullAndNotEmpty(request)) {
			if (Utilidades.nullOrZero(request.getOrigen())) {
				listaErrores.add(this.obtenerError(Constantes.ERROR_ID_3));
			} else {
				aplicacionInvocante = new Ab18aAplicacionInvocante();

				// Aplicacion invocante a encontrar
				aplicacionInvocante.setT03IdAplicacion(request.getOrigen());
				try {
					aplicacionInvocante = this.aplicacionInvocanteService.find(aplicacionInvocante);
				} catch (Exception e) {
					listaErrores.add(this.obtenerError(Constantes.ERROR_ID_28));
					Ab18aRecogidaInformacionImpl.logger.error(
							"Ab18aRecogidaInformacionImpl: solicitarInformacion() - Error al buscar la aplicación invocante.", e);
				}

				if (Utilidades.nullOrEmpty(aplicacionInvocante)) {
					// Si no existe no pasa la validación
					listaErrores.add(this.obtenerError(Constantes.ERROR_ID_4));
				}
			}

			if (Utilidades.nullOrZero(request.getIdTicket())) {
				listaErrores.add(this.obtenerError(Constantes.ERROR_ID_25));
			}

			if (Utilidades.nullOrZero(request.getIdOrigen())) {
				listaErrores.add(this.obtenerError(Constantes.ERROR_ID_31));
			} else {
				if (request.getIdOrigen().toString().length() > Constantes.LONGITUD_MAX_ID_ORIGEN) {
					listaErrores.add(this.obtenerError(Constantes.ERROR_ID_32));
				}
			}

			if (Utilidades.nullOrZero(request.getIdPeticionEnvio())) {
				listaErrores.add(this.obtenerError(Constantes.ERROR_ID_35));
			}

			if (Utilidades.nullOrEmpty(listaErrores)) {
				Ab18aPeticionEnvio peticion = new Ab18aPeticionEnvio();
				peticion.setT01IdOrigen(request.getIdOrigen());
				peticion.setT03IdOrigen(request.getOrigen());
				peticion.setT07IdTicket(request.getIdTicket());
				peticion.setT01IdPeticionEnvio(request.getIdPeticionEnvio());
				try {
					DatosBoletin datosBoletin = this.peticionEnvioService.findPeticionRecogida(peticion);

					if (Utilidades.notNullAndNotEmpty(datosBoletin)) {
						// Transformar datos validacion
						if (Utilidades.notNullAndNotEmpty(datosBoletin.getResultValidLogica())) {
							List<ErrorWS> errores = this.obtenerErroresValidacion(datosBoletin.getResultValidLogica());
							if (!errores.isEmpty()) {
								datosBoletin.setErroresValidacion(errores);
							}
						}

						datosBoletin = this.xmlToBase64(datosBoletin);
						Ab18aDatosRespuestaEsentool datosRespuesta = this.peticionEnvioService.findRespuestaWS(datosBoletin.getIdPeticionTicket());
						if (Utilidades.notNullAndNotEmpty(datosRespuesta)) {
							List<String> listadoTedLinks = this.peticionEnvioService.findTedLinks(datosBoletin.getIdPeticionTicket());
							if (listadoTedLinks != null && !listadoTedLinks.isEmpty()) {
								datosRespuesta.setTedLinks(listadoTedLinks);
							}
							List<Ab18aValidacionBoletin> listadoValidaciones = this.peticionEnvioService.findValidaciones(datosBoletin
									.getIdPeticionTicket());
							if (listadoValidaciones != null && !listadoValidaciones.isEmpty()) {
								datosRespuesta.setValidaciones(listadoValidaciones);
							}
							if (Utilidades.notNullAndNotEmpty(datosRespuesta.getErrorEnvioBoletin())) {
								datosRespuesta.setDescError(datosBoletin.getDescError() != null ? datosBoletin.getDescError() : "");
							}
							datosBoletin.setCodError(null);
							datosBoletin.setDescError(null);
							datosBoletin.setDatRespuestaBol(datosRespuesta);
						}

						response.setDatosBoletin(datosBoletin);
					} else {
						listaErrores.add(this.obtenerError(Constantes.ERROR_ID_33));
					}
				} catch (Exception e) {
					listaErrores.add(this.obtenerError(Constantes.ERROR_ID_28));
					Ab18aRecogidaInformacionImpl.logger.error("Ab18aRecogidaInformacionImpl: solicitarInformacion() - Error al buscar la petición.",
							e);
				}
			}
		} else {
			listaErrores.add(this.obtenerError(Constantes.ERROR_ID_34));
		}

		if (listaErrores != null && !listaErrores.isEmpty()) {
			response.getDatosBoletin().setErrores(listaErrores);
		}

		return response;
	}

	/**
	 * Obtiene los errores de validación desde el XML de resultado de validación
	 * lógica
	 * 
	 * @param resultValidLogica
	 *            XML de resultado de validación lógica
	 * @return Listado de errores en objeto {@link ErrorWS}
	 */
	private List<ErrorWS> obtenerErroresValidacion(final String resultValidLogica) {

		List<ErrorWS> listadoErrores = new ArrayList<ErrorWS>();
		String expresionXPATH = Ab18aPropertiesManager.getProperty(Constantes.EXPRESION_XPATH_OBTENER_ERRORES_VALIDACION_LOGICA);

		try {

			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new ByteArrayInputStream(resultValidLogica.getBytes()));

			XPathFactory xpathfactory = XPathFactory.newInstance();
			XPath xpath = xpathfactory.newXPath();

			XPathExpression expr = xpath.compile(expresionXPATH);
			Object result = expr.evaluate(doc, XPathConstants.NODESET);

			NodeList nodes = (NodeList) result;
			if (nodes != null) {
				ErrorWS error;
				for (int i = 0; i < nodes.getLength(); i++) {
					error = new ErrorWS();
					if (nodes.item(i) != null) {
						String atributoError = Ab18aPropertiesManager.getProperty(Constantes.ATRIBUTO_ID_ERROR);
						if (nodes.item(i).getAttributes() != null && nodes.item(i).getAttributes().getNamedItem(atributoError) != null
								&& nodes.item(i).getAttributes().getNamedItem(atributoError).getNodeValue() != null) {
							error.setCodigo(nodes.item(i).getAttributes().getNamedItem(atributoError).getNodeValue());
						}
						if (nodes.item(i).getTextContent() != null) {
							error.setDescripcion(nodes.item(i).getTextContent());
						}
					}
					listadoErrores.add(error);
				}
			}

		} catch (ParserConfigurationException e) {
			Ab18aRecogidaInformacionImpl.logger.error("La configuracion de XPATH es incorrecta: " + resultValidLogica, e);
		} catch (XPathExpressionException e) {
			Ab18aRecogidaInformacionImpl.logger.error("La expresion XPATH es incorrecta: " + expresionXPATH + ". XML: " + resultValidLogica, e);
		} catch (SAXException e) {
			Ab18aRecogidaInformacionImpl.logger.error("No se ha podido analizar el XML: " + resultValidLogica, e);
		} catch (IOException e) {
			Ab18aRecogidaInformacionImpl.logger.error("No se ha podido recuperar el XML: " + resultValidLogica, e);
		}

		return listadoErrores;
	}

	/**
	 * Obtiene el mensaje de error proveniente de base de datos
	 * 
	 * @param id
	 *            Identificador del error
	 * @return Objeto {@link ErrorWS} con el código de error y su descripción
	 */
	private ErrorWS obtenerError(Integer id) {
		Ab18aErrorAplicacion error = new Ab18aErrorAplicacion(id, "", "", "");
		error = this.errorAplicacionService.find(error);

		return new ErrorWS(error.getCodError(), error.getDescripcionError());
	}

	/**
	 * Transforma los datos del envío del boletín y el envío de pasarela a Base
	 * 64
	 * 
	 * @param datosBoletin
	 *            Datos del boletín
	 * @return DatosBoletin Datos del boletín
	 * @throws IOException
	 *             Excepción
	 */
	private DatosBoletin xmlToBase64(DatosBoletin datosBoletin) throws IOException {
		if (Utilidades.notNullAndNotEmpty(datosBoletin.getXmlEnvioBoletin())) {
			StringReader reader = new StringReader(datosBoletin.getXmlEnvioBoletin());
			datosBoletin.setXmlEnvioBoletin(Base64.encodeBase64String(this.comprimirFichero(IOUtils.toByteArray(reader), "xmlEnvioBoletin")));
		}
		if (Utilidades.notNullAndNotEmpty(datosBoletin.getXmlEnvioPasarela())) {
			StringReader reader = new StringReader(datosBoletin.getXmlEnvioPasarela());
			datosBoletin.setXmlEnvioPasarela(Base64.encodeBase64String(this.comprimirFichero(IOUtils.toByteArray(reader), "xmlEnvioPasarela")));
		}
		return datosBoletin;
	}

	/**
	 * Comprime un fichero y le asigna un nombre
	 * 
	 * @param fichero
	 *            Fichero a comprimir
	 * @param nombreFichero
	 *            Nombre del fichero
	 * @return byte[] Fichero comprimido
	 * @throws IOException
	 *             Excepción
	 */
	private byte[] comprimirFichero(byte[] fichero, String nombreFichero) throws IOException {

		ByteArrayOutputStream bytesZip = new ByteArrayOutputStream();
		ZipOutputStream zos = new ZipOutputStream(bytesZip);

		zos.putNextEntry(new ZipEntry(nombreFichero));
		zos.write(fichero);
		zos.closeEntry();
		zos.close();

		return bytesZip.toByteArray();
	}

	/**
	 * Envío al boletín mediante JMS
	 * 
	 * @param idPeticionEnvio
	 *            Identificador del envío
	 * @return int
	 * @throws Exception
	 *             Excepción
	 */
	@WebMethod
	public int envioBoletinJMS(@WebParam(name = "idPeticionEnvio") Integer idPeticionEnvio) throws Exception {
		logger.debug("Entramos en envioBoletinJMS");
		ConnectionFactory connectionFactory = null;
		Connection connection = null;
		Ab18aPeticionEnvio peticion = new Ab18aPeticionEnvio();
		peticion.setT01IdPeticionEnvio(idPeticionEnvio);
		logger.debug("Buscando datos");
		DatosBoletin datos = this.peticionEnvioService.findPeticionById(idPeticionEnvio);
		logger.debug("Datos encontrado");
		logger.debug("Buscando respuesta esentool");
		Ab18aDatosRespuestaEsentool respuesta = this.peticionEnvioService.findRespuestaWS(idPeticionEnvio);
		logger.debug("Respuesta encontrada");
		try {
			// Y4646S00 registroEnvioJMS =
			// getNuevoRegistroEnvio(origenExpediente, idContrato);
			// this.y46jRegistroColaJMSDao.addRegistro(registroEnvioJMS);

			// PROPIEDADES DINAMICAS

			logger.debug("Generando XML");

			StringBuilder sb = new StringBuilder();
			sb.append("<ns:NotificationBody xmlns:ns=\"com/ejie/notification/xml\">");
			sb.append("<ns:Property>");
			sb.append("<ns:Name>ORIGEN</ns:Name>");
			sb.append("<ns:Value>").append(datos.getIdOrigenAplicacion()).append("</ns:Value>");
			sb.append("</ns:Property>");
			sb.append("<ns:xmlValue>");
			sb.append("<![CDATA[").append(this.generarMensajeEvento(datos, respuesta)).append("]]>");
			sb.append("</ns:xmlValue>");
			sb.append("</ns:NotificationBody>");

			logger.debug("XML Generado: " + sb.toString());

			// CONEXION AL CONTEXTO DEL WEBLOGIC
			Hashtable<String, String> environment = new Hashtable<String, String>();
			environment.put(Context.INITIAL_CONTEXT_FACTORY, Constantes.INITIAL_CONTEXT_FACTORY);
			environment.put(Context.PROVIDER_URL, Constantes.URL_PROVIDER);
			Context jndiContext = new InitialContext(environment);
			connectionFactory = (ConnectionFactory) jndiContext.lookup(Constantes.CONN_FACTORY);

			Destination destino = (Destination) jndiContext.lookup(Constantes.QUEUE_NAME);
			connection = connectionFactory.createConnection();
			Session session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
			MessageProducer producer = session.createProducer(destino);
			TextMessage message = session.createTextMessage();

			// PROPIEDADES OBLIGATORIAS
			message.setStringProperty(ENTIDAD, "HACIENDA Y FINANZAS");
			message.setStringProperty(SISTEMA, "AB18A");
			message.setStringProperty(TIPOLOGIA, "CONTRATACION");
			message.setStringProperty(WHAT, "PUBLICACION_BOLETIN");

			// PROPIEDADES RECOMENDADAS
			String tmStamp = Ab18aFechas.getTime("yyyy-MM-dd HH:mm:ss", Calendar.getInstance().getTime());
			message.setStringProperty(TIMESTAMP, tmStamp);
			// message.setStringProperty(CORRELATIONID,
			// String.valueOf(registroEnvioJMS.getId()));

			message.setText(sb.toString());
			logger.debug("Texto del mensaje: " + sb.toString());

			// OBTENER EL TOKEN DE XL-NET
			String tokenXlNet = "";
			try {
				N38APISesion n38Sesion = new N38APISesion();
				Document token = n38Sesion.n38APISesionCrearApp("AB18A");
				tokenXlNet = this.DOM2String(token);
			} catch (Exception e) {
				logger.error("Error al recuperar la sesión de XLNets: " + e);
			}

			message.setStringProperty(TOKEN_SESION, tokenXlNet);
			logger.debug("Token de XLNETS obtenido");

			// ENVIO DEL MENSAJE A LA COLA
			producer.send(message);
			logger.debug("Mensaje enviado a la cola con éxito");

			// IDENTIFICADOR DEL EVENTO EN EL ENRUTADOR
			// registroEnvioJMS.setJmsMessageId(message.getJMSMessageID());

			// registroEnvioJMS.setXml(sb.toString());

			// registroEnvioJMS.setEstadoEnvio(Y4646S00.ESTADO_ENVIADO);

			// this.y46jRegistroColaJMSDao.updateRegistroEnviado(registroEnvioJMS);

			// PROCESAMIENTO DEL MSGID EN LA APP GENERADORA
			// … codigo a implantar por la aplicación genradora
			return 0;

		} catch (NamingException e) {
			logger.error("envioBoletinJMS", "Error al publicar en la cola JMS: error NamingException, " + e.getCause().getMessage());
		} catch (JMSException e) {
			logger.error("envioBoletinJMS", "Error al publicar en la cola JMS: error JMSException, " + e.getCause().getMessage());
		} catch (Exception e) {
			logger.error("envioBoletinJMS", "Error al publicar en la cola JMS: error Exception, " + e.getCause().getMessage());
		} finally {
			if (connection != null) {
				try {
					connection.close();
				} catch (Exception e) {
					logger.error("envioBoletinJMS", "Error al publicar en la cola JMS: error al cerrar la conexion");
				}
			}
		}

		return 1;
	}

	private String DOM2String(Document token) throws TransformerException {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
		StringWriter writer = new StringWriter();
		transformer.transform(new DOMSource(token), new StreamResult(writer));
		String output = writer.getBuffer().toString().replaceAll("\n|\r", "");
		return output;
	}

	private String generarMensajeEvento(DatosBoletin datos, Ab18aDatosRespuestaEsentool respuesta) throws Exception {

		Ab18aMensajeEvento evento = new Ab18aMensajeEvento();

		logger.debug("generarMensajeEvento: Entramos en generarMensajeEvento");

		try {
			evento.setIdPeticionEnvio(datos.getIdPeticionTicket());
			evento.setCodExpediente(datos.getCodExpediente());
			evento.setCodEstado(datos.getCodEstado() != null ? datos.getCodEstado() : "");
			evento.setIdOrigen(datos.getIdOrigen());
			evento.setIdOrigenAplicacion(datos.getIdOrigenAplicacion());
			evento.setCodError(datos.getCodError() != null ? datos.getCodError() : "");
			evento.setDescError(datos.getDescError() != null ? datos.getDescError() : "");
			if (respuesta != null) {
				evento.setFechaActualizacion(respuesta.getFechaActualizacion() != null ? respuesta.getFechaActualizacion() : null);
				evento.setFechaPublicacion(respuesta.getFechaPublicacion() != null ? respuesta.getFechaPublicacion() : null);
			}
		} catch (Exception e) {
			logger.debug("Error al generar el objeto del evento " + e);
			throw e;
		}

		logger.debug("generarMensajeEvento: Salimos en generarMensajeEvento");

		return mensajeEventoToXml(evento);
	}

	private String mensajeEventoToXml(Ab18aMensajeEvento mensajeEvento) throws Exception {
		logger.debug("mensajeEventoToXml: Entramos en mensajeEventoToXml");
		String xml = "";
		final StringWriter stringWriter = new StringWriter();
		try {
			JAXBContext context = JAXBContext.newInstance(Ab18aMensajeEvento.class);
			Marshaller marshaller = context.createMarshaller();
			marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
			marshaller.setProperty(Marshaller.JAXB_ENCODING, "iso-8859-1");

			marshaller.marshal(mensajeEvento, stringWriter);

		} catch (JAXBException e) {
			logger.error("mensajeEventoToXml: Error al parsear el mensaje a XML, causa: " + e.getMessage());
			throw e;
		}

		xml = stringWriter.toString();
		logger.debug("mensajeEventoToXml: Salimos de mensajeEventoToXml");
		return xml;
	}
}
